package C4LJ::DB;

use DBI;
use C4LJ::Config;
use Carp qw(croak);
use strict;

my $dbh;

=head1 NAME 

C4LJ::DB - create a connection to the database

=head1 DESCRIPTION

You will never need to call this module since it is called by C4LJ::Articles.

=head1 AUTHOR

Eric Lease Morgan <emorgan@nd.edu>

=cut


sub dbh {

	if ( $dbh ) { return $dbh }
	$dbh = DBI->connect( $C4LJ::Config::DATA_SOURCE, $C4LJ::Config::USERNAME, $C4LJ::Config::PASSWORD ) || croak( 'Can\'t connect to database.' );
	return $dbh;
}

1;
