use Test::More tests => 15;
use strict;

# use the module
use_ok('Musings::Subject');

# create object
my $subject = Musings::Subject->new();
isa_ok($subject, "Musings::Subject");

# subject term
$subject->subject_term('origami');
is($subject->subject_term(), 'origami', 'set subject_term()');

# subject note
$subject->subject_note('the art of folding paper');
is($subject->subject_note(), 'the art of folding paper', 'set subject_note()');

# commit
is($subject->commit(), '1', 'commit()');

# id
my $id = $subject->subject_id();
like ($id, qr/^\d+$/, 'get subject_id()');

# get record based on an id
$subject = Musings::Subject->new(id => $id);
is ($subject->subject_term(), 'origami', 'get subject_term() matches based on id');
is ($subject->subject_note(), 'the art of folding paper', 'get subject_note() matches based on id');

# get record based on facet name
$subject = Musings::Subject->new(name => 'origami');
is ($subject->subject_id(), $id, 'get id() matches based on name');
is ($subject->subject_note(), 'the art of folding paper', 'get subject_note() matches based on name');

# update a facet record
$subject->subject_term('Paperfolding');
$subject->subject_note('an art as well a craft');
$subject->commit();
$subject = Musings::Subject->new(id => $id);
is ($subject->subject_term(), 'Paperfolding', 'commit() update');
is ($subject->subject_note(), 'an art as well a craft', 'commit() update');

# get facets
my @f = Musings::Subject->get_subjects(sort => 'name');
my $facet_count = scalar(@f);
like ($facet_count, qr/^\d+$/, "get_facets() $facet_count found");

# get facets by criteria
@f = Musings::Subject->get_subjects(value => 'Paperfolding', field => 'subject_term', sort => 'name');
my $facet_test_name = $f[0]->subject_term();
is ("$facet_test_name", 'Paperfolding', 'get_facets(value, field)');

# delete a facet record
is ($subject->delete(), '1', 'delete() a facet');
