#!/usr/bin/perl

# make-dictionary.pl - create an Aspell dictionary from a swish-e index
# Eric Lease Morgan <eric_morgan@infomotions.com>
# Thanks to Bill Mosely how inspired this hack.

# 2003/12/08 - got it working after reading Perl Cookbook
# 2003/11/27 - first investigations; Thanksgiving


# define a few contants
my $SWISH  = '/usr/local/bin/swish-e -T INDEX_WORDS_ONLY -f /usr/local/apache/htdocs/musings/etc/musings.idx';
my $ASPELL = '/usr/local/bin/aspell --lang=en create master /usr/local/apache/htdocs/musings/etc/musings.dict';


######################################################
# no configuration should be necessary below this line


# practice good programming
use strict;

# initialize input and output words
my $words  = undef;

# get the list of words from the index
open INPUT, "$SWISH |";
while (<INPUT>) {

	chop;                      # get rid of trailing return
	next if (! /^[A-Za-z]+$/); # discard word that include numbers
	$words .= $_ . ' ';        # build list of valid words

}
close INPUT;

# create a dictionary
open OUTPUT, "| $ASPELL";
print OUTPUT $words;
close OUTPUT;

# done; too simple!
exit;
