package MyLibrary::Auth::Basic;

use base qw(MyLibrary::Auth);
use MyLibrary::Patron;
use Carp qw(croak cluck); 
use strict;


{
		# Allowable object attributes with defaults
        my %_attr_data =
				(	auth_method			=> 'BASIC',
					crypt_password		=> undef,
					file				=> __FILE__
                );

		# Class methods used to operate on encapsulated data
		sub _attr_defaults {
			return \%_attr_data;
        }
        sub _standard_keys {
                keys %_attr_data;
        }
}

sub _encrypt_password {
	my $self = shift;
	my ($patron, $password) = @_;
	if (defined $password) {
		my $salt = substr($patron->password(), 0, 2);
		my $crypted_pw = crypt($password, $salt);
		return $crypted_pw;
	} else {
		croak "Password not indicated for encryption.\n";
	}
}

sub authenticate {
	my $self = shift;
	my %args = @_;
	if (defined $args{username} && defined $args{password} && $args{username} ne '' && $args{password} ne '' && $args{username} !~ /^\s/ && $args{password} !~ /^\s/) {
		my $patron = MyLibrary::Patron->new(username => $args{username});
		unless (defined $patron) {
			my $_auth_obj = $self->SUPER::_attr_hash();
			$_auth_obj->{${$self}}->{status_accessor}->($self, 'failed authentication');
			$_auth_obj->{${$self}}->{_sess_ref}->param('status', $self->status());
			return 'username failure';
		}
		my $crypt_password = $self->_encrypt_password($patron, $args{password});
		if ($crypt_password eq $patron->password()) {
			my $_auth_obj = $self->SUPER::_attr_hash();
			$_auth_obj->{${$self}}->{status_accessor}->($self, 'authenticated');
			$_auth_obj->{${$self}}->{crypt_password} = $crypt_password;
			$_auth_obj->{${$self}}->{username} = $args{username};
			$_auth_obj->{${$self}}->{user_id} = $patron->id();
			$_auth_obj->{${$self}}->{_sess_ref}->param('crypt_password', $crypt_password);
			$_auth_obj->{${$self}}->{_sess_ref}->param('username', $args{username});
			$_auth_obj->{${$self}}->{_sess_ref}->param('user_id', $patron->id());
			$_auth_obj->{${$self}}->{_sess_ref}->param('_logged_in', '1');
			$_auth_obj->{${$self}}->{_sess_ref}->param('status', $self->status());
			$_auth_obj->{${$self}}->{_sess_ref}->expire('_logged_in', '+1m');
			return 'success';
		} else {
			my $_auth_obj = $self->SUPER::_attr_hash();
			$_auth_obj->{${$self}}->{status_accessor}->($self, 'failed authentication');
			$_auth_obj->{${$self}}->{_sess_ref}->param('status', $self->status());
			return 'password failure';
		}
	} else {
		return 'error';
	}
}

1;
